#include <iostream>
using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl tacka3.cpp

class Tacka {
private:             // Clanovi p[odaci (privatni)
    int x, y;
public:              // Konstruktori
    Tacka() {};
    Tacka(int novo_x, int novo_y) {set(novo_x, novo_y);}
    Tacka(const Tacka &src) {set(src.x, src.y);}

// Operacije

    Tacka add(const Tacka &pt);
    Tacka sub(const Tacka &pt);
    Tacka operator+(const Tacka &pt) {return add(pt);}
    Tacka operator-(const Tacka &pt) {return sub(pt);}

// Ostale funkcije-clanovi

    void set(int novo_x, int novo_y);
    int get_x() const {return x;}
    int get_y() const {return y;}
};

int main() {

    Tacka tacka1(20, 20);
    Tacka tacka2(0, 5);
    Tacka tacka3(-10, 25);
    Tacka tacka4 = tacka1 + tacka2 + tacka3;

    cout << "Tacka je " << tacka4.get_x();
    cout << ", " << tacka4.get_y() << "." << endl;

    system("PAUSE");
    return 0;
}

void Tacka::set(int novo_x, int novo_y) {
    if (novo_x < 0)
        novo_x *= -1;
    if (novo_y < 0)
        novo_y *= -1;
    x = novo_x;
    y = novo_y;
}

Tacka Tacka::add(const Tacka &pt) {
    Tacka novo_pt;
    novo_pt.x = x + pt.x;
    novo_pt.y = y + pt.y;
    return novo_pt;
}

Tacka Tacka::sub(const Tacka &pt) {
    Tacka novo_pt;
    novo_pt.x = x - pt.x;
    novo_pt.y = y - pt.y;
    return novo_pt;
}
